/*
 * Decompiled with CFR 0.152.
 */
package standard;

import com.nokia.mid.appl.calc2.Local;
import common.control.DisplayManager;
import common.ui.DisplaySizes;
import common.ui.EditPanel;
import common.util.Calculator;
import common.util.Tools;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class StandardEditPanel
extends EditPanel {
    private static final int DOUGLAS_8_WIDTH = 236;
    private static final int DOUGLAS_8_HEIGHT = 123;
    private static final int DOUGLAS_8_X_POS = 2;
    private static final int DOUGLAS_8_Y_POS = 2;
    private static final int DOUGLAS_8_MEMORY_SYMBOL_X_POS = 8;
    private static final int DOUGLAS_8_TEXT_LINES_X_POS = 227;
    private static final int DOUGLAS_8_TEXT_LINE_1_Y_POS = 28;
    private static final int DOUGLAS_8_TEXT_LINE_2_Y_POS = 60;
    private static final int DOUGLAS_8_TEXT_LINE_3_Y_POS = 92;
    private static final int DOUGLAS_8_RESULT_LINE_X_POS_1 = 10;
    private static final int DOUGLAS_8_RESULT_LINE_X_POS_2 = 230;
    private static final int DOUGLAS_8_RESULT_LINE_Y_POS = 90;
    private static final int DOUGLAS_8_OPERATOR_ADD_DIVIDE_X_POS = 13;
    private static final int DOUGLAS_8_OPERATOR_SUBSTRACT_X_POS = 15;
    private static final int DOUGLAS_8_OPERATOR_MULTIPLY_X_POS = 14;
    private static final int DOUGLAS_8_OPERATOR_1_Y_POS = 60;
    private static final int DOUGLAS_8_OPERATOR_2_Y_POS = 92;
    private static final int S60_3_2_LS_TEXT_LINE_1_Y_POS = 26;
    private static final int S60_3_2_LS_TEXT_LINE_2_Y_POS = 50;
    private static final int S60_3_2_LS_TEXT_LINE_3_Y_POS = 78;
    private static final int S60_3_2_LS_RESULT_LINE_Y_POS = 74;
    private static final int S60_3_2_LS_OPERATOR_1_Y_POS = 48;
    private static final int S60_3_2_LS_OPERATOR_2_Y_POS = 78;
    private static final int S60_3_2_LANDSCAPE_HEIGHT = 100;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_OPERAND_1 = 1;
    private static final int STATE_OPERATOR = 2;
    private static final int STATE_OPERAND_2 = 3;
    private static final int STATE_RESULT = 4;
    private int textLinesXPos = 0;
    private int textLine1YPos = 0;
    private int textLine2YPos = 0;
    private int textLine3YPos = 0;
    private int resultLineXPos1 = 0;
    private int resultLineXPos2 = 0;
    private int resultLineYPos = 0;
    private int operatorAddDivideXPos = 0;
    private int operatorSubstractXPos = 0;
    private int operatorMultiplyXPos = 0;
    private int operator1YPos = 0;
    private int operator2YPos = 0;
    private String currentOperand = null;
    private int currentBinaryOperator = -1;
    private String accumulator = null;
    private String operand1 = null;
    private String operand2 = null;

    public StandardEditPanel(DisplaySizes displaySize) {
        super(displaySize);
        if (displaySize == DisplaySizes.DOUGLAS_8 || displaySize == DisplaySizes.S60_3_1 || displaySize == DisplaySizes.S60_3_2 || displaySize == DisplaySizes.S60_3_1_OLD || displaySize == DisplaySizes.S60_3_2_SDK) {
            this.width = 236;
            this.height = 123;
            this.xPos = 2;
            this.yPos = 2;
            this.memoryStatusSymbolXPos = 8;
            this.textLinesXPos = 227;
            this.textLine1YPos = 28;
            this.textLine2YPos = 60;
            this.textLine3YPos = 92;
            this.resultLineXPos1 = 10;
            this.resultLineXPos2 = 230;
            this.resultLineYPos = 90;
            this.operatorAddDivideXPos = 13;
            this.operatorSubstractXPos = 15;
            this.operatorMultiplyXPos = 14;
            this.operator1YPos = 60;
            this.operator2YPos = 92;
        } else if (displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || displaySize == DisplaySizes.TUBE_LANDSCAPE_GAME || displaySize == DisplaySizes.TUBE_PORTRAIT_GAME || displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
            this.width = 236;
            this.height = 100;
            this.xPos = 2;
            this.yPos = 2;
            this.memoryStatusSymbolXPos = 8;
            this.textLinesXPos = 227;
            this.textLine1YPos = 26;
            this.textLine2YPos = 50;
            this.textLine3YPos = 78;
            this.resultLineXPos1 = 10;
            this.resultLineXPos2 = 230;
            this.resultLineYPos = 74;
            this.operatorAddDivideXPos = 13;
            this.operatorSubstractXPos = 15;
            this.operatorMultiplyXPos = 14;
            this.operator1YPos = 48;
            this.operator2YPos = 78;
        }
        this.changeState(0);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.displaySize == DisplaySizes.DOUGLAS_8 || this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD) {
            this.font = Font.getFont((int)0, (int)0, (int)16);
        }
        if (this.displaySize == DisplaySizes.S60_3_2_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_2 || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_GAME || this.displaySize == DisplaySizes.TUBE_PORTRAIT_GAME || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
            this.font = Font.getFont((int)0, (int)0, (int)16);
        }
        switch (this.currentState) {
            case 0: {
                if (this.currentOperand != null) {
                    g.drawString(Tools.getInstance().replaceDecimalSeparator(this.currentOperand), this.textLinesXPos, this.textLine3YPos, 24);
                    break;
                }
                g.setColor(0x888888);
                g.drawString("0", this.textLinesXPos, this.textLine3YPos, 24);
                g.setColor(0);
                break;
            }
            case 1: {
                if (this.currentOperand == null) break;
                g.drawString(Tools.getInstance().replaceDecimalSeparator(this.currentOperand), this.textLinesXPos, this.textLine3YPos, 24);
                break;
            }
            case 2: {
                if (this.accumulator == null || this.currentBinaryOperator == -1) break;
                g.drawString(Tools.getInstance().replaceDecimalSeparator(this.accumulator), this.textLinesXPos, this.textLine2YPos, 24);
                if (this.currentBinaryOperator == 0 || this.currentBinaryOperator == 3) {
                    this.drawCurrentBinaryOperator(g, this.operatorAddDivideXPos, this.operator2YPos);
                    break;
                }
                if (this.currentBinaryOperator == 1) {
                    this.drawCurrentBinaryOperator(g, this.operatorSubstractXPos, this.operator2YPos);
                    break;
                }
                if (this.currentBinaryOperator != 2) break;
                this.drawCurrentBinaryOperator(g, this.operatorMultiplyXPos, this.operator2YPos);
                break;
            }
            case 3: {
                if (this.accumulator == null || this.currentOperand == null || this.currentBinaryOperator == -1) break;
                g.drawString(Tools.getInstance().replaceDecimalSeparator(this.accumulator), this.textLinesXPos, this.textLine2YPos, 24);
                g.drawString(Tools.getInstance().replaceDecimalSeparator(this.currentOperand), this.textLinesXPos, this.textLine3YPos, 24);
                if (this.currentBinaryOperator == 0 || this.currentBinaryOperator == 3) {
                    this.drawCurrentBinaryOperator(g, this.operatorAddDivideXPos, this.operator2YPos);
                    break;
                }
                if (this.currentBinaryOperator == 1) {
                    this.drawCurrentBinaryOperator(g, this.operatorSubstractXPos, this.operator2YPos);
                    break;
                }
                if (this.currentBinaryOperator != 2) break;
                this.drawCurrentBinaryOperator(g, this.operatorMultiplyXPos, this.operator2YPos);
                break;
            }
            case 4: {
                if (this.operand1 == null || this.operand2 == null || this.accumulator == null || this.currentBinaryOperator == -1) break;
                g.drawString(Tools.getInstance().replaceDecimalSeparator(this.operand1), this.textLinesXPos, this.textLine1YPos, 24);
                g.drawString(Tools.getInstance().replaceDecimalSeparator(this.operand2), this.textLinesXPos, this.textLine2YPos, 24);
                if (this.currentBinaryOperator == 0 || this.currentBinaryOperator == 3) {
                    this.drawCurrentBinaryOperator(g, this.operatorAddDivideXPos, this.operator1YPos);
                } else if (this.currentBinaryOperator == 1) {
                    this.drawCurrentBinaryOperator(g, this.operatorSubstractXPos, this.operator1YPos);
                } else if (this.currentBinaryOperator == 2) {
                    this.drawCurrentBinaryOperator(g, this.operatorMultiplyXPos, this.operator1YPos);
                }
                g.drawLine(this.resultLineXPos1, this.resultLineYPos, this.resultLineXPos2, this.resultLineYPos);
                g.drawString("=", this.operatorAddDivideXPos, this.operator2YPos, 20);
                g.drawString(Tools.getInstance().replaceDecimalSeparator(this.accumulator), this.textLinesXPos, this.textLine3YPos, 24);
            }
        }
    }

    private int checkKeyCode(int keyCode) {
        int key = keyCode;
        if (key > 57 && key != 107 && key != 105) {
            int[] codes = new int[]{109, 114, 116, 121, 102, 103, 104, 118, 98, 110};
            boolean found = false;
            int i = 0;
            while (!found) {
                if (key != codes[i]) {
                    ++i;
                    continue;
                }
                key = 48 + i;
                found = true;
            }
        }
        return key;
    }

    public void keyPressed(int keyCode, int gameAction) {
        int key = this.checkKeyCode(keyCode);
        super.keyPressed(keyCode, gameAction);
        switch (this.currentState) {
            case 0: {
                if ((keyCode < 48 || keyCode > 57) && keyCode < 98) break;
                this.currentOperand = "" + (char)key;
                this.changeState(1);
                break;
            }
            case 1: 
            case 3: {
                if ((keyCode < 48 || keyCode > 57) && (keyCode < 98 || this.currentOperand.length() >= 10)) break;
                if (this.currentOperand.equals("0") || this.currentOperand.equals("-0")) {
                    this.currentOperand = "" + (char)key;
                    break;
                }
                this.currentOperand = this.currentOperand + (char)key;
                break;
            }
            case 2: {
                if ((keyCode < 48 || keyCode > 57) && keyCode < 98) break;
                this.currentOperand = "" + (char)key;
                this.changeState(3);
                break;
            }
            case 4: {
                if ((keyCode < 48 || keyCode > 57) && keyCode < 98) break;
                this.currentOperand = "" + (char)key;
                this.currentBinaryOperator = -1;
                this.changeState(1);
            }
        }
    }

    public void handlePressedButton(int buttonType) {
        switch (this.currentState) {
            case 0: {
                if (buttonType == 30) {
                    this.currentOperand = "0.";
                    this.changeState(1);
                    break;
                }
                if (buttonType != 26 || !this.recallFromMemory()) break;
                this.changeState(1);
                break;
            }
            case 1: {
                if (buttonType == 30) {
                    if (this.currentOperand.length() > 8 || this.currentOperand.indexOf(".") >= 0) break;
                    this.currentOperand = this.currentOperand + ".";
                    break;
                }
                if (buttonType == 0 || buttonType == 1 || buttonType == 2 || buttonType == 3) {
                    this.currentBinaryOperator = buttonType;
                    this.accumulator = Tools.getInstance().doubleToString(Tools.getInstance().parseDouble(this.currentOperand));
                    this.currentOperand = null;
                    this.changeState(2);
                    break;
                }
                if (buttonType == 8 || buttonType == 5 || buttonType == 6 || buttonType == 7 || buttonType == 21) {
                    this.performUnaryOperation(buttonType);
                    break;
                }
                if (buttonType == 25) {
                    this.saveToMemory();
                    break;
                }
                if (buttonType != 26) break;
                this.recallFromMemory();
                break;
            }
            case 2: {
                if (buttonType == 30) {
                    this.currentOperand = "0.";
                    this.changeState(3);
                    break;
                }
                if (buttonType == 0 || buttonType == 1 || buttonType == 2 || buttonType == 3) {
                    this.currentBinaryOperator = buttonType;
                    break;
                }
                if (buttonType != 26 || !this.recallFromMemory()) break;
                this.changeState(3);
                break;
            }
            case 3: {
                if (buttonType == 30) {
                    if (this.currentOperand.length() > 8 || this.currentOperand.indexOf(".") >= 0) break;
                    this.currentOperand = this.currentOperand + ".";
                    break;
                }
                if (buttonType == 0 || buttonType == 1 || buttonType == 2 || buttonType == 3) {
                    if (!this.performBinaryOperation()) break;
                    this.currentBinaryOperator = buttonType;
                    this.changeState(2);
                    break;
                }
                if (buttonType == 8 || buttonType == 5 || buttonType == 6 || buttonType == 7 || buttonType == 21) {
                    this.performUnaryOperation(buttonType);
                    break;
                }
                if (buttonType == 25) {
                    this.saveToMemory();
                    break;
                }
                if (buttonType == 26) {
                    this.recallFromMemory();
                    break;
                }
                if (buttonType != 4 || !this.performBinaryOperation()) break;
                this.changeState(4);
                break;
            }
            case 4: {
                if (buttonType == 30) {
                    this.currentOperand = "0.";
                    this.currentBinaryOperator = -1;
                    this.changeState(1);
                    break;
                }
                if (buttonType == 0 || buttonType == 1 || buttonType == 2 || buttonType == 3) {
                    this.currentBinaryOperator = buttonType;
                    this.changeState(2);
                    break;
                }
                if (buttonType == 8 || buttonType == 5 || buttonType == 6 || buttonType == 7 || buttonType == 21) {
                    this.performUnaryOperation(buttonType);
                    break;
                }
                if (buttonType == 25) {
                    this.saveToMemory();
                    break;
                }
                if (buttonType != 26 || !this.recallFromMemory()) break;
                this.changeState(1);
            }
        }
        if (buttonType == 24) {
            this.changeState(0);
        }
    }

    public void removeLastSymbol() {
        switch (this.currentState) {
            case 1: {
                if (this.currentOperand.length() == 1 || this.currentOperand.length() == 2 && this.currentOperand.charAt(0) == "-".charAt(0)) {
                    this.changeState(0);
                    break;
                }
                this.currentOperand = this.currentOperand.substring(0, this.currentOperand.length() - 1);
                break;
            }
            case 2: {
                this.currentOperand = this.accumulator;
                this.currentBinaryOperator = -1;
                this.changeState(1);
                break;
            }
            case 3: {
                if (this.currentOperand.length() == 1 || this.currentOperand.length() == 2 && this.currentOperand.charAt(0) == "-".charAt(0)) {
                    this.currentOperand = null;
                    this.changeState(2);
                    break;
                }
                this.currentOperand = this.currentOperand.substring(0, this.currentOperand.length() - 1);
                break;
            }
            case 4: {
                this.accumulator = this.operand1;
                this.currentOperand = this.operand2;
                this.changeState(3);
            }
        }
        this.repaint();
    }

    protected void initEditPanel() {
        this.currentOperand = null;
        this.currentBinaryOperator = -1;
        this.accumulator = null;
        this.operand1 = null;
        this.operand2 = null;
        if (this.calculatorCanvas != null) {
            this.calculatorCanvas.removeClearCommand();
        }
    }

    protected void saveToMemory() {
        if (this.currentOperand == null || this.currentOperand.length() == 0) {
            return;
        }
        if (this.currentOperand.equals("0") || this.currentOperand.equals("-0")) {
            this.memory = null;
            this.memoryDirty = false;
        } else {
            this.memory = this.currentOperand;
            this.memoryDirty = true;
        }
    }

    protected boolean recallFromMemory() {
        if (this.memory == null || this.memory.length() == 0) {
            return false;
        }
        this.currentOperand = this.memory;
        this.repaint();
        return true;
    }

    protected void changeState(int newState) {
        if (newState < 0 && newState > 4) {
            return;
        }
        this.currentState = newState;
        switch (this.currentState) {
            case 0: {
                this.initEditPanel();
                break;
            }
            case 1: {
                if (this.calculatorCanvas == null) break;
                this.calculatorCanvas.addClearCommand();
            }
        }
    }

    private void changeSign() {
        if (this.currentOperand == null || this.currentOperand.length() == 0 || this.currentOperand.equals("0")) {
            return;
        }
        if (this.currentOperand.equals("0.")) {
            this.currentOperand = "0";
            return;
        }
        char sign = this.currentOperand.charAt(0);
        if (sign == "-".charAt(0)) {
            if (this.currentOperand.length() > 1) {
                this.currentOperand = this.currentOperand.substring(1);
            }
        } else if (this.currentOperand.length() < 10) {
            this.currentOperand = "-" + this.currentOperand;
        } else {
            String outOfRange = Local.getText(11, new String[]{String.valueOf(10)});
            Alert alert = new Alert(Local.getText(28), outOfRange, null, AlertType.INFO);
            DisplayManager.getInstance().push(alert);
        }
    }

    private void performUnaryOperation(int unaryOperator) {
        double operandDouble = Tools.getInstance().parseDouble(this.currentOperand);
        double result = 0.0;
        switch (unaryOperator) {
            case 5: {
                result = Calculator.getInstance().percentage(operandDouble);
                break;
            }
            case 6: {
                result = Calculator.getInstance().square(operandDouble);
                break;
            }
            case 7: {
                try {
                    result = Calculator.getInstance().sqrt(operandDouble);
                    break;
                }
                catch (ArithmeticException e) {
                    Alert alert = new Alert(Local.getText(28), e.getMessage(), null, AlertType.INFO);
                    DisplayManager.getInstance().push(alert);
                    return;
                }
            }
            case 8: {
                try {
                    result = Calculator.getInstance().reciprocal(operandDouble);
                    break;
                }
                catch (ArithmeticException e) {
                    Alert alert = new Alert(Local.getText(28), e.getMessage(), null, AlertType.INFO);
                    DisplayManager.getInstance().push(alert);
                    return;
                }
            }
            case 21: {
                this.changeSign();
                if (this.currentState == 4) {
                    this.changeState(1);
                }
                return;
            }
        }
        String tempResult = Tools.getInstance().doubleToStringRounded(result, 10);
        if (tempResult != null) {
            this.currentOperand = Tools.getInstance().removeNegativezero(tempResult);
            if (this.currentState == 4) {
                this.changeState(1);
            }
        } else {
            String outOfRange = Local.getText(11, new String[]{String.valueOf(10)});
            Alert alert = new Alert(Local.getText(28), outOfRange, null, AlertType.INFO);
            DisplayManager.getInstance().push(alert);
        }
    }

    private boolean performBinaryOperation() {
        double operand1Double = Tools.getInstance().parseDouble(this.accumulator);
        double operand2Double = Tools.getInstance().parseDouble(this.currentOperand);
        this.operand1 = Tools.getInstance().doubleToString(operand1Double);
        this.operand2 = Tools.getInstance().doubleToString(operand2Double);
        double result = 0.0;
        switch (this.currentBinaryOperator) {
            case 0: {
                result = Calculator.getInstance().add(operand1Double, operand2Double);
                break;
            }
            case 1: {
                result = Calculator.getInstance().substract(operand1Double, operand2Double);
                break;
            }
            case 2: {
                result = Calculator.getInstance().multiply(operand1Double, operand2Double);
                break;
            }
            case 3: {
                try {
                    result = Calculator.getInstance().divide(operand1Double, operand2Double);
                    break;
                }
                catch (ArithmeticException e) {
                    Alert alert = new Alert(Local.getText(28), e.getMessage(), null, AlertType.INFO);
                    DisplayManager.getInstance().push(alert);
                    return false;
                }
            }
        }
        String tempResult = Tools.getInstance().doubleToStringRounded(result, 10);
        if (tempResult != null) {
            this.currentOperand = this.accumulator = Tools.getInstance().removeNegativezero(tempResult);
            return true;
        }
        String outOfRange = Local.getText(11, new String[]{String.valueOf(10)});
        Alert alert = new Alert(Local.getText(28), outOfRange, null, AlertType.INFO);
        DisplayManager.getInstance().push(alert);
        return false;
    }

    private void drawCurrentBinaryOperator(Graphics g, int xPos, int yPos) {
        switch (this.currentBinaryOperator) {
            case 0: {
                g.drawString("+", xPos, yPos, 20);
                break;
            }
            case 1: {
                g.drawString("-", xPos, yPos, 20);
                break;
            }
            case 2: {
                g.drawString("x", xPos, yPos, 20);
                break;
            }
            case 3: {
                g.drawString("\u00f7", xPos, yPos, 20);
            }
        }
    }
}

